<?php
/**
 * The template for displaying Search Results pages.
 *
 * @author Dueper Design
 * @package Dueper Theme
 */

get_header(); ?>
<header class="page-header">
  <div class="container">
    <h1 class="page-title"><?php printf( __( 'Search Results for: %s', 'blanka' ), '<span>' . get_search_query() . '</span>' ); ?></h1>
  </div><!--container-->
</header><!-- .page-header -->
<div class="container">
  <div class="row">
    <div class="col-sm-3-4">
      <?php if ( have_posts() ) : ?>
        <?php while ( have_posts() ) : the_post(); ?>
          <article>
            <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">
              <h4 class="media-heading"><?php the_title(); ?></h4>
            </a>
            <?php the_excerpt(); ?>
          </article>
        <?php endwhile;
      else : ?>
        <div class="container">
          <p><?php _e( 'Sorry, but nothing matched your search terms. Please try again with some different keywords.','blanka'); ?></p>
          <?php get_search_form(); ?>
        </div><!-- container -->
      <?php endif; ?>
    </div><!--col-md-8-->
    <div class="col-sm-1-4">
      <?php get_sidebar(); ?>
    </div><!--col-md-4-->
  </div><!--row-->
</div><!--container-->

<?php get_footer(); ?>
