<?php
// Loading All CSS Stylesheets
if (!function_exists('load_css_files')) {
  add_action('wp_enqueue_scripts', 'load_css_files');
  function load_css_files() {
    //SASS
    wp_enqueue_style('main', get_template_directory_uri(). '/dist/css/styles.min.css?v=2');
    wp_enqueue_style('vendor', get_template_directory_uri(). '/dist/css/vendor.min.css?v=2');
    wp_enqueue_style('style', get_template_directory_uri().'/style.css?v=2');
  }
}

// Loading all JS Script Files.
if (!function_exists('load_js_files')) {
  add_action('wp_enqueue_scripts', 'load_js_files');
  function load_js_files() {
    //Original
    wp_enqueue_script('vendor', get_template_directory_uri().'/dist/js/vendor.min.js', array('jquery'),'1.0', true);
    wp_enqueue_script('gmaps', 'https://maps.googleapis.com/maps/api/js?key=AIzaSyDi4wYgHpk9b_bG1raFgKe5qyRlet9C7Ng&v=3.exp&sensor=false', null, null, false);
    wp_enqueue_script('main', get_template_directory_uri().'/dist/js/main.min.js', array('jquery'),'1.0', true );
  }
}
