<?php
/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.4.0
 */

defined( 'ABSPATH' ) || exit;

get_header();

/**
 * Hook: woocommerce_before_main_content.
 *
 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
 * @hooked woocommerce_breadcrumb - 20
 * @hooked WC_Structured_Data::generate_website_data() - 30
 */
// do_action( 'woocommerce_before_main_content' );

?>
<header class="woocommerce-products-header">
	<?php
	$term = get_queried_object();
	$alt_title = get_field('titolo_alternativo',$term);
	?>
	<?php if ( apply_filters( 'woocommerce_show_page_title', true ) ) : ?>
		<?php if($alt_title) : ?>
			<?= $alt_title ?>
		<?php else: ?>
		<h1 class="woocommerce-products-header__title page-title"><?php woocommerce_page_title(); ?></h1>
		<?php endif; ?>
	<?php endif; ?>

	<?php
	/**
	 * Hook: woocommerce_archive_description.
	 *
	 * @hooked woocommerce_taxonomy_archive_description - 10
	 * @hooked woocommerce_product_archive_description - 10
	 */
	if(is_shop()){
		$string = get_field('shop_description','option');
		$string_short = get_field('shop_description_excerpt','option');

	} else {
		$string = get_field('descrizione_categoria', $term);
		$string_short = get_field('descrizione_categoria_excerpt', $term);
	}


		if($string) {
			echo '<div class="excerpt-container">';
			echo '<div class="products-description-excerpt">';
			echo $string_short;
			echo '<span class="toggle-excerpt"><a> '. __('Leggi di più ','Blanka') .'</a></span>';
			echo '</div>';
				if($string) {
					echo '<div class="excerpt-see-more">';
					echo $string;
					echo '<a class="toggle-excerpt active">'. __(' Nascondi','blanka') .'</a></div>';
				}
			echo '</div>';
			
		}
	?>
</header>
<?php
if ( woocommerce_product_loop() ) {

	/**
	 * Hook: woocommerce_before_shop_loop.
	 *
	 * @hooked wc_print_notices - 10
	 * @hooked woocommerce_result_count - 20
	 * @hooked woocommerce_catalog_ordering - 30
	 */
	//do_action( 'woocommerce_before_shop_loop' );
	echo '<div class="filter-wrapper"><a href="#" class="filter-toggler">'. __("Filtri","blanka") .'<i class="icon-menu"></i></a>';
	woocommerce_catalog_ordering();
	echo '</div>';
	echo '<aside class="sidebar-wrapper">';
		get_sidebar('shop');
	echo '</aside>';
	echo '<aside class="sidebar-wrapper-mobile">';
		get_sidebar('shop-mobile');
	echo '</aside>';
	echo '<main class="page-content">';
		the_widget('WC_Widget_Layered_Nav_Filters');
		// echo do_shortcode('[woocommerce_product_filter]');
		woocommerce_product_loop_start();

		if ( wc_get_loop_prop( 'total' ) ) {
			while ( have_posts() ) {
				the_post();

				/**
				 * Hook: woocommerce_shop_loop.
				 *
				 * @hooked WC_Structured_Data::generate_product_data() - 10
				 */
				do_action( 'woocommerce_shop_loop' );

				wc_get_template_part( 'content', 'product' );
			}
			 $default_posts_per_page = get_option( 'posts_per_page' );
			 if(wc_get_loop_prop( 'total' ) > $default_posts_per_page) {
			 	echo '<div class="text-center">';
			 		echo '<a href="#" class="custom-underline lined-up" id="load-more">Carica altri prodotti</a>';
			 	echo '</div>';
			 }
		}

		woocommerce_product_loop_end();

	echo '</main>';
	echo '<div class="clearfix"></div>';
	/**
	 * Hook: woocommerce_after_shop_loop.
	 *
	 * @hooked woocommerce_pagination - 10
	 */
	do_action( 'woocommerce_after_shop_loop' );
} else {
	/**
	 * Hook: woocommerce_no_products_found.
	 *
	 * @hooked wc_no_products_found - 10
	 */
	do_action( 'woocommerce_no_products_found' );
}

/**
 * Hook: woocommerce_after_main_content.
 *
 * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
 */
//do_action( 'woocommerce_after_main_content' );

/**
 * Hook: woocommerce_sidebar.
 *
 * @hooked woocommerce_get_sidebar - 10
 */
// do_action( 'woocommerce_sidebar' );

get_footer();
