<?php
$image['placeholder'] = get_the_post_thumbnail_url(get_the_ID(), 'placeholder');
$image['default'] = get_the_post_thumbnail_url(get_the_ID(), 'large');
$image['retina'] = get_the_post_thumbnail_url(get_the_ID(), 'large');
$attribute_skip = get_field('attribute_skip', 'option');


global $product;
$brand_title = $product->get_attribute('brand');
$price = wc_price($product->get_regular_price());
$price_on_sale = wc_price($product->get_sale_price());

do_action('woocommerce_before_shop_loop_item');
?>

<article <?php post_class('product-teaser'); ?>>
  <figure class="">
    <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">
      <img class="lazy-blanka img-responsive" src="<?= $image['retina'] ?>" data-src="<?= $image['default'] ?>" data-src-retina="<?= $image['retina'] ?>" alt="<?php the_title(); ?>" title="<?php the_title(); ?>" longdesc="<?php the_title(); ?>" />
    </a>
  </figure>
  <div class="content">
    <header>
      <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">
        <h4 class="brand-title">

          <?php if ($brand_title && $brand_title !== ($attribute_skip))
            echo $brand_title;
          ?>
        </h4>
        <h3 class="product-title"><?php the_title(); ?></h3>
      </a>
    </header>
    <?php if ($price_on_sale) :
      echo '<label class="original-price override">' . $price . '</label>';
      echo '<label class="sale-price">' . $price_on_sale . '</label>';
    else :
      echo '<label class="original-price">' . $price . '</label>';
    endif; ?>
  </div>
  <div class="clearfix"></div>
</article>
<!--post-class-->

<?php
/**
 * Hook: woocommerce_after_shop_loop_item.
 *
 * @hooked woocommerce_template_loop_product_link_close - 5
 * @hooked woocommerce_template_loop_add_to_cart - 10
 */

remove_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_product_link_close');
remove_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart');


do_action('woocommerce_after_shop_loop_item');
?>

<?php if (function_exists('the_blogpost_json_ld')) :
  the_blogpost_json_ld($post->ID);
endif; ?>