<?php

/**
 * The template for displaying product content in the single-product.php template
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.4.0
 */

defined('ABSPATH') || exit;

/**
 * Hook: woocommerce_before_single_product.
 *
 * @hooked wc_print_notices - 10
 */
do_action('woocommerce_before_single_product');

if (post_password_required()) {
	echo get_the_password_form(); // WPCS: XSS ok.
	return;
}
?>

<?php
$shipping = get_field('shipping_prods', 'option');
$subtitle = get_field('subtitle');
$payment = get_field('payment_prods', 'option');
global $product;
// ATTRIBUTES
$brand_title = $product->get_attribute('brand');
$size = $product->get_attribute('size');
$weight = $product->get_attribute('weight');
$karat = $product->get_attribute('karat');
$material = $product->get_attribute('material');
// PRICES
$price = wc_price($product->get_regular_price());
$price_on_sale = wc_price($product->get_sale_price());
?>

<div id="product-<?php the_ID(); ?>" <?php wc_product_class(); ?>>
	<div class="container-fluid">
		<div class="row row-padding">
			<header class="page-header">
				<?php the_title('<h1 class="page-title">', '</h1>'); ?>
				<?php if ($subtitle) echo '<h2 class="page-subtitle">' . $subtitle . '</h2>'; ?>
			</header>
			<div class="col-1 col-sm-1-4 product-section-header">
				<!-- PRODUCT DESCRIPTION -->
				<!-- PROD ATTRIBUTES -->
				<h5 class="title-expandable mobile-closed">
					<?php _e('Descrizione', 'blanka'); ?>
					<img class="icon" src="<?php echo get_template_directory_uri(); ?>/dist/images/arrow_right.png">
				</h5>
				<div class="collapsable-text mobile-collapsable-closed">
					<?php the_content(); ?>
				</div>
				<h5 class="title-expandable mobile-closed">
					<?php _e('Dettagli', 'blanka'); ?>
					<img class="icon" src="<?php echo get_template_directory_uri(); ?>/dist/images/arrow_right.png">
				</h5>
				<div class="collapsable-text mobile-collapsable-closed">
					<?php //if($size || $karat || $material || $weight):
					?>
					<!-- <ul class="details-list"> -->
					<?php
					// if($size) echo '<li><label>Misure:</label>'.$size.'</li>';
					// if($karat) echo '<li><label>Carati / Qualità pietra:</label>'.$karat.'</li>';
					// if($material) echo '<li><label>Metallo / Materiale:</label>'.$material.'</li>';
					// if($weight) echo '<li><label>Peso:</label>'.$weight.'</li>';
					echo wc_display_product_attributes($product);

					?>
					<!-- </ul> -->
					<?php //endif;
					?>
				</div>
				<!-- SHIPPING -->
				<?php if ($shipping) : ?>
					<h5 class="title-expandable mobile-closed">
						<?php _e('Spedizioni', 'blanka'); ?>
						<img class="icon" src="<?php echo get_template_directory_uri(); ?>/dist/images/arrow_right.png">
					</h5>
					<div class="collapsable-text mobile-collapsable-closed" style="display:none">
						<?= $shipping ?>
						<?php _e('Are you looking for some help?', 'blanka'); ?><br />
					<a class="contact-link custom-underline lined-up gold" href="<?php echo get_permalink(get_page_by_path('assistenza')); ?>"><?php _e('Contact us', 'blanka'); ?></a>
					</div>
				<?php endif; ?>
			</div><!-- col -->
			<div class="col-1 col-sm-1-2 product-section-gallery">
				<div class="galleries-wrapper">
					<!-- BIG SLIDER -->
					<div class="big-slider">
						<?php woocommerce_show_product_images(); ?>
					</div>
					<!-- SMALL SLIDER -->
					<?php
					// $attachment_ids = $product->get_gallery_attachment_ids();
					// $number_el = count($attachment_ids);
					// if($number_el > 1) : 
					?>
					<div class="small-slider">
						<?php woocommerce_show_product_images(); ?>
					</div>
					<?php // endif; 
					?>
				</div>
			</div><!-- col -->
			<div class="col-1 col-sm-1-4 buy-section">
				<!-- PRICE -->
				<?php if ($price_on_sale) :
					echo '<label class="sale-price">' . $price_on_sale . '</label>';
					echo '<label class="original-price override">' . $price . '</label>';
				else :
					echo '<label class="original-price">' . $price . '</label>';
				endif;
				if (!get_field('disallow_shop', 'option')  /*|| current_user_can('edit_pages')*/) :
					// BUTTON
					woocommerce_template_single_add_to_cart();
				else :
					echo '<div class="clearfix"></div><br />';
					echo '<a href="mailto:info@ledial.it" class="btn btn-primary boxed"><span>';
					_e('Contattaci', 'blanka');
					echo '</span></a>';
				endif;
				?>
				<span class="product-code"><?= sprintf(__('%s Codice prodotto: %s %s'), '<strong>', '</strong>', $product->get_sku()) ?>
				<div class="product-pay">
					<?= $payment ?>
				</div>
					<!-- <a class="with-icon" href="#">
					<img src="<?php //echo get_template_directory_uri();
								?>/dist/images/icon_portagioie.png" />
					<br />
					<label><?php //_e('Aggiungi al Portagioie','blanka');
							?></label>
				</a> -->
			</div><!-- col -->
		</div><!-- row -->
		<div class="row">
			<?php get_template_part('inc/related/_related', 'products'); ?>
		</div><!-- row -->
	</div><!-- container -->

	<?php
	/**
	 * Hook: woocommerce_before_single_product_summary.
	 *
	 * @hooked woocommerce_show_product_sale_flash - 10
	 * @hooked woocommerce_show_product_images - 20
	 */
	// do_action( 'woocommerce_before_single_product_summary' );
	?>

	<!-- <div class="summary entry-summary"> -->
	<?php
	/**
	 * Hook: woocommerce_single_product_summary.
	 *
	 * @hooked woocommerce_template_single_title - 5
	 * @hooked woocommerce_template_single_rating - 10
	 * @hooked woocommerce_template_single_price - 10
	 * @hooked woocommerce_template_single_excerpt - 20
	 * @hooked woocommerce_template_single_add_to_cart - 30
	 * @hooked woocommerce_template_single_meta - 40
	 * @hooked woocommerce_template_single_sharing - 50
	 * @hooked WC_Structured_Data::generate_product_data() - 60
	 */
	// do_action( 'woocommerce_single_product_summary' );
	?>
	<!-- </div> -->

	<?php
	/**
	 * Hook: woocommerce_after_single_product_summary.
	 *
	 * @hooked woocommerce_output_product_data_tabs - 10
	 * @hooked woocommerce_upsell_display - 15
	 * @hooked woocommerce_output_related_products - 20
	 */
	// do_action( 'woocommerce_after_single_product_summary' );
	?>
</div>

<?php do_action('woocommerce_after_single_product'); ?>