<?php
$image['placeholder'] = get_the_post_thumbnail_url(get_the_ID(), 'placeholder');
$image['default'] = get_the_post_thumbnail_url(get_the_ID(), 'medium');
$image['retina'] = get_the_post_thumbnail_url(get_the_ID(), 'large');
$city = get_field('citta');
$address = get_field('indirizzo');
$link = get_field('gmap_link');
// if($link) {
  // $link = $link;
  // $target = '_blank';
// } else {
  $link = get_permalink();
  $target = '_self';
// }
?>

<article <?php post_class('negozio-teaser'); ?> data-id="<?= $id ?>">
  <figure>
    <?php if($link):?>
      <a href="<?php echo $link; ?>" target="<?php echo $target; ?>">
    <?php endif;?>
      <img class="lazy-blanka" src="<?= $image['placeholder'] ?>" data-src="<?= $image['default'] ?>" data-src-retina="<?= $image['retina'] ?>"
      alt="<?php the_title(); ?>" title="<?php the_title(); ?>" alt="<?= $address ?>"/>
    <?php if($link):?>
      </a>
    <?php endif;?>
  </figure>
  <div class="content">
    <span class="open-map"><?php _e('Scopri di più','blanka');?></span>
    <header>
      <?php if($link):?>
        <a href="<?php echo $link; ?>" target="<?php echo $target; ?>">
      <?php endif;?>
        <div class="city">
          <img class="icon" src="<?php echo get_template_directory_uri(); ?>/dist/images/icon-popup-marker.svg">
          <?php if($city) echo '<h5>'.$city.'</h5>';?>
        </div>

        <div class="address">
          <?php if($address) echo '<h3>'.$address.'</h3>';?>
          <?php if($link):?>
            <div>
            <a href="<?php echo $link; ?>" target="<?php echo $target; ?>" class="custom-underline lined-up"><?php _e("orari e contatti", "blanka"); ?></a>
            <span> ></span>
            </div>
        </div>
        </a>
      <?php endif;?>
    </header>
  </div>
</article><!--post-class-->

<?php if( function_exists('the_blogpost_json_ld') ):
  the_blogpost_json_ld($post->ID);
endif; ?>
